<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContentLanguage extends Model 
{

    protected $table = 'lim_content_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_content_id', 'uri', 'name', 'summary', 'content');
    protected $visible = array('lim_language_id', 'lim_content_id', 'uri', 'name', 'summary', 'content');

    public function content()
    {
        return $this->belongsTo('App\Models\Content', 'lim_content_id');
    }

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

}